/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModSounds;

public class S130Entity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float damage = 300.0f;
    private float explosionDamage = 80.0f;
    private float explosionRadius = 8.0f;
    private float gravity = 0.0f;

    public S130Entity(EntityType<? extends S130Entity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public S130Entity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.f_19811_ = true;
        this.durability = 20;
    }

    public S130Entity(LivingEntity entity, Level level, float damage, float explosionDamage, float explosionRadius) {
        super((EntityType)ModEntities.S_130.get(), (Entity)entity, level);
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.durability = 20;
    }

    public S130Entity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends S130Entity>)((EntityType)ModEntities.S_130.get()), level);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Damage", this.damage);
        pCompound.m_128350_("ExplosionDamage", this.explosionDamage);
        pCompound.m_128350_("Radius", this.explosionRadius);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Damage")) {
            this.damage = pCompound.m_128457_("Damage");
        }
        if (pCompound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = pCompound.m_128457_("ExplosionDamage");
        }
        if (pCompound.m_128441_("Radius")) {
            this.explosionRadius = pCompound.m_128457_("Radius");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.SMALL_ROCKET.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage((Entity)entity, (DamageSource)ModDamageTypes.causeProjectileHitDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork((int)3, () -> ((S130Entity)this).m_146870_());
                    }
                    this.m_9236_().m_46961_(resultPos, true);
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    public void causeExplode(Vec3 vec3) {
        new CustomExplosion.Builder((Entity)this).attacker(this.m_19749_()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }

    public void m_8119_() {
        ServerLevel serverLevel;
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1) {
                double l = this.m_20184_().m_82553_();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
                    Vec3 pos = startPos.m_82549_(this.m_20184_().m_82541_().m_82490_(i));
                    ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123777_, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.001, (boolean)true);
                }
            }
        }
        if (this.f_19797_ == 3 && !this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)this.f_19854_, (double)this.f_19855_, (double)this.f_19856_, (int)15, (double)0.8, (double)0.8, (double)0.8, (double)0.01, (boolean)true);
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123777_, (double)this.f_19854_, (double)this.f_19855_, (double)this.f_19856_, (int)10, (double)0.8, (double)0.8, (double)0.8, (double)0.01, (boolean)true);
        }
        if (this.f_19797_ > 100 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                S130Entity.causeRocketExplode((ThrowableItemProjectile)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), this.explosionDamage, this.explosionRadius, 1.0f);
            }
            this.m_146870_();
        }
        this.destroyBlock();
    }

    public static void causeRocketExplode(ThrowableItemProjectile projectile, @Nullable DamageSource source, float damage, float radius, float damageMultiplier) {
        new CustomExplosion.Builder((Entity)projectile).damageSource(source).damage(damage).radius(radius).damageMultiplier(damageMultiplier).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
        projectile.m_146870_();
    }

    private PlayState movementPredicate(AnimationState<S130Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.rpg.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.ROCKET_ENGINE.get();
    }

    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_SOUND.get();
    }

    public float getVolume() {
        return 0.8f;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public boolean forceLoadChunk() {
        return true;
    }
}

